/* Copyright (C) 2014-2021 m-privacy GmbH. All Rights Reserved.
 *
 * This is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this software; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307,
 * USA.
 *
 *
 * SOUND HANDLER
 * This is the interface to m-privacy's TightGate-Pro TigerVNC client
 * sound system. It should be used to initiate and quit the sound
 * connection between the local sound player daemon and the
 * TightGate-Pro server.
 *
 * TODO: It works only for Woe32 systems, not for Unix. There should
 * be an magical configuration for the local running pulseaudio daemon
 * on Unix someday.
 */

#include <stdio.h>
#include <stdlib.h>
#include <sys/stat.h>
#include "rfb/LogWriter.h"
#include "tgpro_helpers.h"
#if defined(WIN32) || defined(WIN64)
#include <winsock2.h>
#include <windows.h>
#endif
#include "tgpro_environment.h"

#if defined(WIN32) || defined(WIN64)

#define TGPRO_SUBDIR "TightGate-Pro"

const char* tgpro::tgpro_path = NULL;
static rfb::LogWriter vlog("tgpro_helpers");

#if defined(WIN32) || defined(WIN64)
bool tgpro::dir_exists(const char* dir) {
	if (!dir)
		return false;
	while (*dir != '\0' && *dir == '\\')
		++dir;
	DWORD dwAttrib = GetFileAttributes(dir);
	return (dwAttrib != INVALID_FILE_ATTRIBUTES &&
		(dwAttrib & FILE_ATTRIBUTE_DIRECTORY));
}
#else
bool tgpro::dir_exists(const char* dir) {
	if (!dir)
		return false;
	struct stat dir_stat;
	const int err = stat(dir, &dir_stat);
	return (err != -1) && (S_ISDIR(dir_stat.st_mode));
}
#endif /* defined(WIN32) || defined(WIN64) */

char* const tgpro::has_tgpro_installpath_subdir(const char* path, const char* subdir) {
	vlog.info("starte has_tgpro_installpath_subdir()");
	if (!path || !subdir)
		return NULL;
	const size_t p_len = strlen(path) + strlen(subdir) + 2;
	char* complete_path = new char[p_len];
	if (!strlen(path))
		snprintf(complete_path, p_len, "%s", subdir);
	else
		snprintf(complete_path, p_len, "%s\\%s", path, subdir);

	if (dir_exists(complete_path)) {
		vlog.info("Pfad existiert: %s", complete_path);
		return complete_path;
	}
	vlog.info("Pfad existiert NICHT: %s", complete_path);
	delete[] complete_path;
	return NULL;
}

const char* const tgpro::get_installpath_subdir(char* subdir) {
	char* complete_path;

	if (get_tgpro_path())
		if ((complete_path = has_tgpro_installpath_subdir(get_tgpro_path(), subdir)) != NULL)
			return complete_path;

	if (get_start_path())
		if ((complete_path = has_tgpro_installpath_subdir(get_start_path(), subdir)) != NULL)
			return complete_path;

	if ((complete_path = has_tgpro_installpath_subdir("", subdir)) != NULL)
		return complete_path;

	return "";
}

#endif /* defined(WIN32) || defined(WIN64) */
