/* Copyright (C) 2005 Martin Koegler
 * Copyright (C) 2010 TigerVNC Team
 * Copyright (C) 2016-2023 m-privacy GmbH
 *
 * This is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this software; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307,
 * USA.
 */

#ifndef __RDR_TLSOUTSTREAM_H__
#define __RDR_TLSOUTSTREAM_H__

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#ifdef HAVE_GNUTLS
#include <gnutls/gnutls.h>
#include <rdr/OutStream.h>

#define TLSKEY 1

namespace rdr {

  class TLSOutStream : public OutStream {
  public:
    TLSOutStream(OutStream* out, gnutls_session session);
    virtual ~TLSOutStream();

    void cork(bool enable, int key=0, QPrio prio=QPRIOMEDIUM) { out->cork(enable, TLSKEY, prio); }
    virtual int bufferUsage(int key=0, QPrio prio=QPRIOMEDIUM) { return (queueEmpty(prio) || flushActive) ? 0 : 1; }
    void flush(int key=0, QPrio prio=QPRIOMEDIUM, bool wait=false);
    void printBufferUsage();

    OutStream* out;

  protected:
    static THREAD_FUNC flushThread(void* param);
    THREAD_ID flushThreadId;
    static TGVNC_CONDITION_TYPE buffersAvailableCondition;
    static MUTEX_TYPE buffersAvailableConditionLock;
    static TGVNC_CONDITION_TYPE flushedCondition[QPRIONUM];
    static MUTEX_TYPE flushedConditionLock[QPRIONUM];

  private:
    size_t writeTLS(const U8* data, size_t length);
    static ssize_t vec_func(gnutls_transport_ptr str, const giovec_t * iov, int iovcnt);

    gnutls_session session;
    gnutls_transport_ptr recv, send;
    U32 bufferStats[MAXBUFFERSIZE];

    U64 flushCalls;
    bool flushActive;
  };
};

#endif
#endif
