/* 
 * Copyright (C) 2004 Red Hat Inc.
 * Copyright (C) 2005 Martin Koegler
 * Copyright (C) 2010 TigerVNC Team
 * Copyright (C) 2014-2017 m-privacy GmbH
 *    
 * This is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this software; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307,
 * USA.
 */

#ifndef __C_SECURITY_TLS_H__
#define __C_SECURITY_TLS_H__

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#ifndef HAVE_GNUTLS
#error "This header should not be compiled without HAVE_GNUTLS defined"
#endif

#include <rfb/CSecurity.h>
#include <rfb/Security.h>
#include <rfb/UserMsgBox.h>
#include <rdr/InStream.h>
#include <rdr/OutStream.h>
#include <gnutls/gnutls.h>

namespace rfb {
  class UserMsgBox;
  class CSecurityTLS : public CSecurity {
  public:
    CSecurityTLS(CConnection* cc, bool _anon, bool _requireclientcert);
    virtual ~CSecurityTLS();
    virtual bool processMsg();
    virtual unsigned int getType() const { return anon ? secTypeTLSNone : secTypeX509None; }
    virtual const char* description() const
      { return anon ? "TLS Encryption without VncAuth" : "X509 Encryption without VncAuth"; }
    virtual bool isSecure() const { return !anon; }
    static void setDefaults();

    static StringParameter X509CA;
    static StringParameter X509CRL;
    static StringParameter x509cert;
    static StringParameter x509key;
    static BoolParameter tlsClear;
    static BoolParameter tlsNormal;
    static UserMsgBox *msg;
    static char * ciphersuite;

  protected:
    void shutdown(bool needbye);
    void freeResources();
    void getCipher();
    void setParam();
    void checkSession();
    CConnection *client;

  private:
    gnutls_session session;
    gnutls_anon_client_credentials anon_cred;
    gnutls_certificate_credentials cert_cred;
    bool anon;
    bool requireclientcert;

    char *cafile, *crlfile, *certfile, *keyfile;

    rdr::InStream* tlsis;
    rdr::OutStream* tlsos;

    rdr::InStream* rawis;
    rdr::OutStream* rawos;
  };
}

#endif
