/* Copyright 2017-2023 m-privacy GmbH.
 *
 * This is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this software; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307,
 * USA.
 */

#ifndef __SAUTOTRANSFER_MIME_H__
#define __SAUTOTRANSFER_MIME_H__

#ifndef WIN32

#include <list>
#include <magic.h>
#include <pwd.h>

#include <rfb/SAutotransferDirWatcher.h>

class SAutotransferMime: public SAutotransferDirWatcher
{
public:
	SAutotransferMime();

	const char* getDirToWatch() override;
	void processFile(char* filename) override;

private:
	char* autotransferNowDir;
	bool checkFile(char* filename);

	struct magic_set* magicSet;
	std::list<const char*> allowedMimeTypes;
	std::list<const char*> packerCheckTypes;
	int checkMagic(char* filename);
	void initMagicFile();

	void logTransferIfNecessary(const char* filename, const char* mimeType, const bool magicOk);
	void checkGlibPacker(char * filename, const char * mimeTypeLibmagic);
	bool checkSingleFile(char *filename, char **mimeTypeLibmagicP);
	bool checkTree(char *dirname);
	bool unpackAndCheck(char *name);
	void loadAllowedMimeTypes();
	time_t lastAllowedMimeTypesRead;
};

#endif /* ifndef WIN32 */
#endif /* __SAUTOTRANSFER_MIME_H__ */
