/*Copyright (C) 2014-2020 m-privacy GmbH */

#ifndef __STREAMDIALOG_H__
#define __STREAMDIALOG_H__

#include <map>

#include <FL/Fl_Window.H>

#include "CConn.h"

class Fl_Widget;
class Fl_Group;
class Fl_Check_Button;
class Fl_Round_Button;
class Fl_Input;
class Fl_Int_Input;
class Fl_Choice;

typedef void (StreamCallback)(void*);

class StreamDialog : public Fl_Window {
protected:
  StreamDialog(CConn* cc_);
  ~StreamDialog();

public:
  static void showDialog(CConn* cc);

  static void addCallback(StreamCallback *cb, void *data = NULL);
  static void removeCallback(StreamCallback *cb);

  void show(void);

protected:
  void loadOptions(void);
  void storeOptions(void);

  void createDevicePage(int tx, int ty, int tw, int th);
  void fillWebcamChoice(void);

  static void handleWebcam(Fl_Widget *widget, void *data);
  static void handleMic(Fl_Widget *widget, void *data);
  static void handleCancel(Fl_Widget *widget, void *data);
  static void handleApply(Fl_Widget *widget, void *data);
  static void handleOK(Fl_Widget *widget, void *data);

protected:
  /* Stream setting */
  Fl_Group *videoGroup;
  Fl_Check_Button *webcamCheckbox;
  Fl_Choice *webcamChoice;
  Fl_Choice *webcamSizeChoice;
  Fl_Group *micGroup;
  Fl_Check_Button *micCheckbox;
#if 0
  Fl_Choice *micChoice;
#endif

private:
  struct AVDevice * webcamList;
  int webcamCount;
  struct AVDevice * micList;
  int micCount;
  struct AVDevice * webcamSizeList;
  int webcamSizeCount;
  CConn* cc;
  bool oldMicSupport;
};
#endif
