#
# Best-effort magic that tries to produce semi-static binaries
# (i.e. only depends on "safe" libraries like libc and libX11)
#
# Note that this often fails as there is no way to automatically
# determine the dependencies of the libraries we depend on, and
# a lot of details change with each different build environment.
#

option(BUILD_STATIC
    "Link statically against most libraries, if possible" OFF)

if(BUILD_STATIC)
  message(STATUS "Attempting to link static binaries...")

  if(APPLE)
    set(JPEG_LIBRARIES "-ljpeg -L/usr/x86_64-apple-darwin19/lib/")
    set(MP_LIBRARIES "-L/usr/x86_64-apple-darwin19/lib/")
    set(ZLIB_LIBRARIES "-lz")
    set(PIXMAN_LIBRARY "-lpixman-1")
  else()
    if (WIN32)
      set(JPEG_LIBRARIES "-Wl,-Bstatic -ljpeg -Wl,-Bdynamic")
      set(MP_LIBRARIES "-Wl,-Bstatic -Wl,-Bdynamic")
      set(ZLIB_LIBRARIES "-Wl,-Bstatic -lz -Wl,-Bdynamic")
      set(PIXMAN_LIBRARY "-Wl,-Bstatic -lpixman-1 -Wl,-Bdynamic")
    else()
      set(JPEG_LIBRARIES "-ljpeg")
#      set(MP_LIBRARIES "-lopenh264 -lzstd")
      set(ZLIB_LIBRARIES "-lz")
      set(PIXMAN_LIBRARY "-lpixman-1")
    endif()
  endif()

  # gettext is included in libc on many unix systems
  if(NOT LIBC_HAS_DGETTEXT)
    set(GETTEXT_LIBRARIES "-lintl -liconv")
    if(APPLE)
      set(GETTEXT_LIBRARIES "${GETTEXT_LIBRARIES} -framework Carbon")
    endif()
  endif()

  if(GNUTLS_FOUND)
    # GnuTLS has historically had different crypto backends
    FIND_LIBRARY(GCRYPT_LIBRARY NAMES gcrypt libgcrypt
      HINTS ${PC_GNUTLS_LIBDIR} ${PC_GNUTLS_LIBRARY_DIRS})
    FIND_LIBRARY(NETTLE_LIBRARY NAMES nettle libnettle
      HINTS ${PC_GNUTLS_LIBDIR} ${PC_GNUTLS_LIBRARY_DIRS})
    FIND_LIBRARY(TASN1_LIBRARY NAMES tasn1 libtasn1
      HINTS ${PC_GNUTLS_LIBDIR} ${PC_GNUTLS_LIBRARY_DIRS})

    if(APPLE)
      set(GNUTLS_LIBRARIES "-lgnutls -lidn2 -lunistring")
    else()
      if(NOT WIN32)
        set(GNUTLS_LIBRARIES "-lgnutls -lunistring -lidn2")
      else()
        set(GNUTLS_LIBRARIES "-lgnutls -lncrypt")
      endif()
    endif()

    if(NOT WIN32)
      if(APPLE)
	set(GNUTLS_LIBRARIES "-lgnutls -lidn2 -lunistring -lgssapi_krb5 -lkrb5 -lk5crypto -lkrb5support -ldl -lcrypto -lcom_err -lresolv")
      else()
        set(GNUTLS_LIBRARIES "-lgnutls -lunistring -lidn2 -lnettle -lhogweed -lgsasl -lssh -lnacl -lgssapi_krb5 -lkrb5 -lk5crypto -lkrb5support -lcrypto -lcom_err -lkeyutils -lb64 -lXcursor -lntlm -lidn -lX11 -lXfixes -lXft -lXrender -lfontconfig -luuid -lXext -lXinerama -lxcb -lXau -lXdmcp -lexpat -lXfont2 -lfreetype -lpng -lresolv -lc -lm -ldl")
        set(GNUTLS_LIBRARIES "-Wl,-Bstatic -lfltk -Wl,-Bdynamic")
      endif()
    else()
      set(GNUTLS_LIBRARIES "${GNUTLS_LIBRARIES} -lnettle -lhogweed")
    endif()

    if(TASN1_LIBRARY)
      set(GNUTLS_LIBRARIES "${GNUTLS_LIBRARIES} -ltasn1")
    endif()
    if(NETTLE_LIBRARY)
      set(GNUTLS_LIBRARIES "${GNUTLS_LIBRARIES} -lhogweed -lnettle -lgmp")
    endif()
    if(GCRYPT_LIBRARY)
      set(GNUTLS_LIBRARIES "${GNUTLS_LIBRARIES} -lgcrypt -lgpg-error")
    endif()

    # GnuTLS uses various crypto-api stuff
    if (WIN32)
      set(GNUTLS_LIBRARIES "${GNUTLS_LIBRARIES} -lcrypt32")
    else()
      if(APPLE)
        set(GNUTLS_LIBRARIES "${GNUTLS_LIBRARIES} -lpthread")
      else()
        set(GNUTLS_LIBRARIES "${GNUTLS_LIBRARIES} -Wl,-Bdynamic -lpthread")
      endif()
    endif()

    # nanosleep() lives here on Solaris
    if(${CMAKE_SYSTEM_NAME} MATCHES "SunOS")
      set(GNUTLS_LIBRARIES "${GNUTLS_LIBRARIES} -lrt")
    endif()

    # GnuTLS uses gettext and zlib, so make sure those are always
    # included and in the proper order
    set(GNUTLS_LIBRARIES "${GNUTLS_LIBRARIES} ${ZLIB_LIBRARIES}")
    set(GNUTLS_LIBRARIES "${GNUTLS_LIBRARIES} ${GETTEXT_LIBRARIES}")

    # The last variables might introduce whitespace, which CMake
    # throws a hissy fit about
    string(STRIP ${GNUTLS_LIBRARIES} GNUTLS_LIBRARIES)
  endif()

  if(FLTK_FOUND)
    if(WIN32)
      set(FLTK_LIBRARIES "-Wl,-Bstatic -lfltk_images -lpng -ljpeg -lfltk -lgdiplus -Wl,-Bdynamic")
      set(FLTK_LIBRARIES "${FLTK_LIBRARIES} -lcomctl32")
    elseif(APPLE)
      set(FLTK_LIBRARIES "-lfltk_images -lpng -ljpeg -lfltk -L/usr/x86_64-apple-darwin19/lib/")
      set(FLTK_LIBRARIES "${FLTK_LIBRARIES} -framework Cocoa")
    else()
      set(FLTK_LIBRARIES "-lpng -ljpeg -lfltk -lXcursor")
      set(FLTK_LIBRARIES "-Wl,-Bstatic -lfltk_images -Wl,-Bdynamic")
      set(FLTK_LIBRARIES "${FLTK_LIBRARIES} -lm")
    endif()

    if(X11_FOUND AND NOT APPLE)
      if(${CMAKE_SYSTEM_NAME} MATCHES "SunOS")
        set(FLTK_LIBRARIES "${FLTK_LIBRARIES} ${X11_Xcursor_LIB} ${X11_Xfixes_LIB} -Wl,-Bstatic -lXft -Wl,-Bdynamic -lfontconfig -luuid -lXext -R/usr/sfw/lib")
      else()
	if(APPLE)
          set(FLTK_LIBRARIES "${FLTK_LIBRARIES} -lXcursor -lXfixes -lXft -lfontconfig -luuid -lexpat -lfreetype -lpng -lbz2 -lXrender -lXext -lXinerama")
	else()
          set(FLTK_LIBRARIES "${FLTK_LIBRARIES} -lXcursor -lXfixes -lXft -lfontconfig -luuid -lexpat -lfreetype -lpng -lbz2 -luuid -lXrender -lXext -lXinerama")
	endif()
      endif()

      set(FLTK_LIBRARIES "${FLTK_LIBRARIES} -lX11 -lxcb -lXau -lXdmcp -ldl")
    endif()
  endif()

  # X11 libraries change constantly on Linux systems so we have to link
  # them statically, even libXext. libX11 is somewhat stable, although
  # even it has had an ABI change once or twice.
  if(X11_FOUND AND NOT ${CMAKE_SYSTEM_NAME} MATCHES "SunOS")
    if(APPLE)
      set(X11_LIBRARIES "-lXext -lX11 -lxcb -lXau -lXdmcp -ldl")
    else()
      set(X11_LIBRARIES "-lXext -lX11 -lxcb -lXau -lXdmcp -ldl")
    endif()
    if(X11_XTest_LIB)
      set(X11_XTest_LIB "-lXtst")
    endif()
    if(X11_Xdamage_LIB)
      set(X11_Xdamage_LIB "-lXdamage")
    endif()
    if(X11_Xrandr_LIB)
      set(X11_Xrandr_LIB "-lXrandr -lXrender")
    endif()
    if(X11_Xi_LIB)
      set(X11_Xi_LIB "-lXi")
    endif()
  endif()

  # This ensures that we don't depend on libstdc++ or libgcc_s
  if(APPLE)
    set(CMAKE_EXE_LINKER_FLAGS "${CMAKE_EXE_LINKER_FLAGS} -nodefaultlibs")
    set(STATIC_BASE_LIBRARIES "-lc++")
  else()
    set(CMAKE_EXE_LINKER_FLAGS "${CMAKE_EXE_LINKER_FLAGS} -Wl,--allow-multiple-definition -nodefaultlibs")
    set(STATIC_BASE_LIBRARIES "-lstdc++")
  endif()

  if(APPLE)
    set(STATIC_BASE_LIBRARIES "${STATIC_BASE_LIBRARIES} -lz")
  else()
    if(WIN32)
#      set(STATIC_BASE_LIBRARIES "${STATIC_BASE_LIBRARIES} -Wl,-Bstatic -lmupdf -lfreetype -lz -ljpeg -lpng -ljbig2dec -Wl,-Bdynamic")
      set(STATIC_BASE_LIBRARIES "${STATIC_BASE_LIBRARIES} -Wl,-Bstatic -lssp -lpcre2-8 -lpoppler -ltiff -lpoppler-glib -lgio-2.0 -lgobject-2.0 -lgmodule-2.0 -lglib-2.0 -lpoppler -ltiff -ljpeg -lpng -ljbig2dec -lcairo -lpixman-1 -ljpeg -lopenjpeg -lfreetype -lpng -lz -lffi -lopenjpeg -lws2_32 -lintl -liconv -lwinpthread -liphlpapi -ldnsapi -lwinmm -lole32 -lgdi32 -lcomdlg32 -lmsimg32 -lstdc++ -Wl,-Bdynamic")
    else()
      set(STATIC_BASE_LIBRARIES "${STATIC_BASE_LIBRARIES} ")
      set(STATIC_BASE_LIBRARIES "${STATIC_BASE_LIBRARIES} -lssh -lnacl -lcrypto -lz -ljemalloc -lpthread")
    endif()
  endif()

  if(WIN32)
    set(STATIC_BASE_LIBRARIES "${STATIC_BASE_LIBRARIES} -lmingw32 -lmoldname -lmingwex")
    set(STATIC_BASE_LIBRARIES "${STATIC_BASE_LIBRARIES} -luser32 -lkernel32 -ladvapi32 -lshell32")
    # mingw has some fun circular dependencies that requires us to link
    # these things again
    set(STATIC_BASE_LIBRARIES "${STATIC_BASE_LIBRARIES} -lmsvcrt -lmsvcrt-os -lgcc_eh -lgcc -lkernel32 -lmingw32")
  else()
    if(APPLE)
      set(STATIC_BASE_LIBRARIES "${STATIC_BASE_LIBRARIES} -lc++ -lc")
#      set(STATIC_BASE_LIBRARIES "${STATIC_BASE_LIBRARIES} -lrt")
    else()
      set(STATIC_BASE_LIBRARIES "${STATIC_BASE_LIBRARIES} -lgcc -lgcc_eh -lc")
      set(STATIC_BASE_LIBRARIES "${STATIC_BASE_LIBRARIES} -Wl,-Bdynamic -lrt")
    endif()
  endif()

  set(CMAKE_CXX_LINK_EXECUTABLE "${CMAKE_CXX_LINK_EXECUTABLE} ${STATIC_BASE_LIBRARIES}")

endif()
