/* Copyright (C) 2005 Martin Koegler
 * Copyright (C) 2010 TigerVNC Team
 * Copyright (C) 2015-2021 m-privacy GmbH
 *
 * This is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this software; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307,
 * USA.
 */

#ifndef __RDR_MULTIINSTREAM_H__
#define __RDR_MULTIINSTREAM_H__

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#ifdef WIN32
#include <winsock.h>
#else
#include <arpa/inet.h>
#endif

#include <rdr/InStream.h>
#include <rdr/MultiStream.h>

namespace rdr {
	/* callbacks return true, if they handled the data, and false, if not */
	struct cbListElement {
		bool (*callback)(const U8*, int);
	};

	class MultiInStream : public InStream {
	public:
		MultiInStream(InStream* in, size_t bufSize = 129 * 1024);
		virtual ~MultiInStream();
		size_t pos();
		void setCallback(unsigned streamId, bool (*cbFunc)(const U8*, int));
		void setShutdown() {
			if (in)
				in->setShutdown();
		}

	private:
		bool overrun(size_t needed);
		inline void checkBufferMove(unsigned packType);
		inline void handleOtherData(unsigned packType);

		unsigned packType;
		size_t packRestSize;
		InStream* in;
		size_t bufSize;
		U8* bufStart[STREAM_QUANTITY];
		U8* bufEnd[STREAM_QUANTITY];
		U8* dataStart[STREAM_QUANTITY];
		U8* dataEnd[STREAM_QUANTITY];
		unsigned streamCounter[STREAM_QUANTITY];
		bool isMultiPart[STREAM_QUANTITY];
		cbListElement callbacks[STREAM_QUANTITY];
		unsigned streamUseCount[STREAM_QUANTITY];
	};
};

#endif
