/* Copyright (C) 2005 Martin Koegler
 * Copyright (C) 2006 OCCAM Financial Technology
 * Copyright (C) 2010 TigerVNC Team
 * Copyright (C) 2012-2018 m-privacy GmbH
 * 
 * This is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this software; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307,
 * USA.
 */
#ifndef __RFB_SSECURITYKRB_H__
#define __RFB_SSECURITYKRB_H__

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <rfb/SConnection.h>
#include <rfb/SSecurity.h>
#include <rfb/SSecurityVeNCrypt.h>
#include <rfb/util.h>
#include <rfb/Configuration.h>

#include <gsasl.h>
#if !defined(WIN32) && !defined(WIN64)
#include <sys/types.h>
#include <pwd.h>
#endif

namespace rfb {
  class SSecurityKrb : public SSecurity {
  public:
    SSecurityKrb(SConnection* sc);
    ~SSecurityKrb();
    virtual bool processMsg();
    virtual unsigned int getType() const { return secTypeX509Krb; };
    virtual const char* getUserName() const { return username; }
    static StringParameter KrbService;
    static StringParameter KrbHostname;
    static StringParameter KrbLdapBind;
    static StringParameter KrbLdapBind2;
    static StringParameter KrbLdapBase;
    static StringParameter KrbLdapAuto;
    static BoolParameter KrbProvideCcache;
    static StringParameter KrbDomainFile;

  private:
    static char * username;
    Gsasl *gsasl_ctx;
    Gsasl_session *gsasl_session;
    unsigned int state;
    size_t maxbuflen, buflen;
    char * buf;
    int rc;
#if !defined(WIN32) && !defined(WIN64)
    struct passwd * pw;
#endif
  };

}
#endif
