/* Copyright (C) 2000-2003 Constantin Kaplinsky.  All Rights Reserved.
 * Copyright (C) 2011 D. R. Commander
 * Copyright 2014 Pierre Ossman for Cendio AB
 * Copyright (C) 2016-2021 m-privacy GmbH, Berlin
 *
 * This is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this software; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307,
 * USA.
 */
#ifndef __RFB_TIGHTMPENCODER_H__
#define __RFB_TIGHTMPENCODER_H__

#include <rfb/Encoder.h>
#include <rfb/MPCompressor.h>

namespace rfb {

	class TightMPEncoder : public Encoder {
	public:
		TightMPEncoder(SConnection* conn);
		virtual ~TightMPEncoder();

		virtual bool isSupported();

		virtual void setMPLevel(int level);
		virtual int getMPLevel();
		virtual void setMPCompression(int value);
		virtual int getMPCompression();

		virtual void writeRect(const PixelBuffer* pb, const Palette& palette, bool needStartEnd, Rect startR);
		virtual void writeSolidRect(int width, int height, const PixelFormat& pf, const rdr::U8* colour);

		static bool acceptSetLevel;
		static int mpLevel;

	protected:
		MPCompressor hc;

	private:
		int mpCompression;
	};
}
#endif
