/* Copyright 2016-2019 m-privacy GmbH.
 *
 * This is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this software; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307,
 * USA.
 */

#ifndef __MAGIC_URL_HELPER_H__
#define __MAGIC_URL_HELPER_H__

#define MAGICURL_INSTALL_PATH "/usr/bin/magicurl"
#define KDEGLOBALS "/.kde/share/config/kdeglobals"
/* For KDE Plasma Desktop environments */
#define KDEGLOBALS2 "/.config/kdeglobals"
#define MIMEAPPS "/.local/share/applications/mimeapps.list"
#define KDEDIR "/.kde/share/config"
/* For KDE Plasma Desktop environments */
#define KDEDIR2 "/.config"
#define APPSDIR "/.local/share/applications"
#define MAGICURL_DESKTOP "/usr/share/applications/magicurl.desktop"
#define MAGICURL_SOCKET ".magicurl"

class MagicUrlHelper {
public:
	MagicUrlHelper();
	~MagicUrlHelper();

	char* getMagicurlPipeName();
	bool maybeSetStandardBrowser();
	int promptStandardBrowser();
	int isUserWantsToSetStandardBrowser();
	int isAskAgainNextTime();
	int isMagicUrlInstalled();
	int setStandardBrowser();
	int resetStandardBrowser();
	static int isStandardBrowser();
	int hasMoved();
	int sendUrlToViewer(const char* url);
#if !defined(WIN32) && !defined(WIN64)
	void updateKdeglobals(char *path = NULL);
	static char* get_magicurl_socket_path();
#endif /*!defined(WIN32) && !defined(WIN64)*/

private:
	char * standard_browser_question;
};

#endif
