/* Copyright 2014-2021 m-privacy GmbH
 *
 * This is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this software; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307,
 * USA.
 */

#ifndef __PRINTDIALOG_H__
#define __PRINTDIALOG_H__

#include <FL/Fl_Double_Window.H>
#include <FL/Fl_Button.H>
#include <FL/Fl_Multiline_Output.H>

#include <rdr/mutex.h>

class PrintDialog : public Fl_Double_Window {
public:
	PrintDialog(const char* window_title);
	~PrintDialog();
	void new_job(const char* pdf_file);

private:
	char* print_file;

	static MUTEX_TYPE print_file_lock;

	void print(char * cur_file);
	void cleanup();

	static void callback_ok(Fl_Widget *widget, void *data);
	static void callback_cancel(Fl_Widget *widget, void *data);

	Fl_Button* ok_butt;
	Fl_Button* cancel_butt;
	Fl_Multiline_Output* text_output;
	const static int window_height = 140;
	const static int window_width = 400;
	const static int butt_width = 70;
	const static int butt_height = 30;
	const static int margin = 5;
};


#endif
