/* Copyright 2011 Pierre Ossman <ossman@cendio.se> for Cendio AB
 * Copyright (C) 2014-2024 m-privacy GmbH
 * 
 * This is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this software; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307,
 * USA.
 */

#ifndef __OPTIONSDIALOG_H__
#define __OPTIONSDIALOG_H__

#include <map>

#include <FL/Fl_Window.H>
#include <FL/Fl_Box.H>

#include "CConn.h"

class Fl_Widget;
class Fl_Group;
class Fl_Check_Button;
class Fl_Round_Button;
class Fl_Input;
class Fl_Int_Input;
class Fl_Choice;

typedef void (OptionsCallback)(void*);

class OptionsDialog : public Fl_Window {
protected:
  OptionsDialog(CConn * _cc = NULL);
  ~OptionsDialog();

public:
  static void showDialog(CConn * _cc = NULL);

  static void addCallback(OptionsCallback *cb, void *data = NULL);
  static void removeCallback(OptionsCallback *cb);

  void show(void);

protected:
  void loadOptions(void);
  void storeOptions(void);

  void createInfoPage(int tx, int ty, int tw, int th);
  void createCompressionPage(int tx, int ty, int tw, int th);
  void createSecurityPage(int tx, int ty, int tw, int th);
  void createInputPage(int tx, int ty, int tw, int th);
  void createScreenPage(int tx, int ty, int tw, int th);
  void createSoundPage(int tx, int ty, int tw, int th);
  void createPrintPage(int tx, int ty, int tw, int th);
  void createStandardBrowserPage(int tx, int ty, int tw, int th);

  void updateConnectionInfoOnMiscPage();

  static void handleCompression(Fl_Widget *widget, void *data);
  static void handleMP(Fl_Widget *widget, void *data);

  static void handleDesktopSize(Fl_Widget *widget, void *data);

  static void handlePrintSupport(Fl_Widget *widget, void *data);
  static void handleSetStandardBrowser(Fl_Widget *widget, void *data);

  static void handleClipboard(Fl_Widget *widget, void *data);

  static void handleCancel(Fl_Widget *widget, void *data);
  static void handleOK(Fl_Widget *widget, void *data);

protected:
  static std::map<OptionsCallback*, void*> callbacks;

  /* Compression */
  Fl_Check_Button *mpCheckbox;
//  Fl_Int_Input *mpInput;

  Fl_Choice *mpCompressionChoice;

  /* Security */
  Fl_Group *autotransferGroup;
  Fl_Check_Button *autotransferSupportCheckbox;

  /* Input */
  Fl_Group *mouseGroup;
  Fl_Group *clipboardGroup;
  Fl_Check_Button *viewOnlyCheckbox;
  Fl_Check_Button *emulateMBCheckbox;
  Fl_Check_Button *acceptClipboardCheckbox;
  Fl_Check_Button *sendClipboardCheckbox;
#if !defined(WIN32) && !defined(__APPLE__)
  Fl_Check_Button *sendPrimaryCheckbox;
#endif
  Fl_Check_Button *systemKeysCheckbox;
  Fl_Choice *menuKeyChoice;

  /* Screen */
  Fl_Check_Button *desktopSizeCheckbox;
  Fl_Int_Input *desktopWidthInput;
  Fl_Int_Input *desktopHeightInput;
  Fl_Check_Button *remoteResizeCheckbox;
  Fl_Check_Button *fullScreenCheckbox;
  Fl_Check_Button *fullScreenAllMonitorsCheckbox;
  Fl_Choice *mpScalingChoice;

  /* Misc. */ // OLD Misc (commented out with #if 0 in OptionsDialog.cxx)
  Fl_Check_Button *sharedCheckbox;
  Fl_Check_Button *dotCursorCheckbox;

  Fl_Check_Button *soundCheckbox;
  Fl_Check_Button *printSupportCheckbox;
  Fl_Int_Input *printIntervalInput;
  Fl_Check_Button *quickPrintCheckbox;
  Fl_Check_Button *standardBrowserPromptCheckbox;

  /* Info */
  Fl_Group *connectionInfoGroup;
  Fl_Box *connectionInfoBox;
  Fl_Group *aboutViewerGroup;

private:
  CConn * cc;
};

#endif
