/* Copyright (C) 2014-2021 m-privacy GmbH. All Rights Reserved.
 *
 * This is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this software; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307,
 * USA.
 *
 *
 * SOUND HANDLER
 * This is the interface to m-privacy's TightGate-Pro TigerVNC client
 * sound system. It should be used to initiate and quit the sound
 * connection between the local sound player daemon and the
 * TightGate-Pro server.
 *
 * TODO: It works only for Woe32 systems, not for Unix. There should
 * be an magical configuration for the local running pulseaudio daemon
 * on Unix someday.
 */

#ifndef __SOUND_HANDLER_H__
#define __SOUND_HANDLER_H__

#include "CConn.h"

#if defined(WIN32) || defined(WIN64)
#include <winsock2.h>
#include <windows.h>
#endif /* defined(WIN32) || defined(WIN64) */

#include <string>
#include <network/Socket.h>

#define SYSTEM_PULSEAUDIO -1
#define OWN_UNIX_PULSEAUDIO 77

#define pulseaudio_exec_win (char*)"pulseaudio.exe"
#define pulseaudio_subdir_win (char*)"pulseaudio"
#define pulseaudio_params (char*)"--use-pid-file=false -n --exit-idle-time=-1 --disallow-module-loading -L \"module-native-protocol-tcp auth-ip-acl=127.0.0.1;%s port=%u\" -L \"module-waveout record=%u\""
#define pulseaudio_params_localhost (char*)"--use-pid-file=false -n --exit-idle-time=-1 --disallow-module-loading -L \"module-native-protocol-tcp auth-ip-acl=127.0.0.1;%s listen=127.0.0.1 port=%u\" -L \"module-waveout record=%u\""

#define pulseaudio_check_running_osx (char*)"%spulseaudio -v --check"
#define pulseaudio_check_running (char*)"pulseaudio --check"
#define pulseaudio_start_osx (char*)"%spulseaudio -v --daemonize -n --realtime --exit-idle-time=-1 --disallow-module-loading -p '%s' -L 'module-coreaudio-detect record=0 playback=1' -L 'module-native-protocol-unix' -L 'module-native-protocol-tcp auth-ip-acl=127.0.0.1;%s port=%u'"
#define pulseaudio_start_unixoid (char*)"pulseaudio --daemonize --exit-idle-time=-1 --disallow-module-loading -L \"module-native-protocol-tcp auth-ip-acl=127.0.0.1;%s port=%u\""
#define pactl_load (char*)"pactl load-module module-native-protocol-tcp auth-ip-acl=%s port=%u"
#define pactl_unload (char*)"pactl unload-module module-native-protocol-tcp #%i"

/**
 * The whole TightGate-Pro sound interface lives in the namespace
 * sound.
 */
namespace sound {
	bool start_sound(int paPort);
	void stop_sound();
	void set_conn(CConn* new_cc);
	void kill_all_pulseaudio_processes();
	void find_free_socket(int paPortMin, int paPortMax, int * paPort_p);
}


#endif /* __SOUND_HANDLER_H__ */
