#include "mp_simple_list.h"
#include "log.h"

struct Node {
	char* data;
	struct Node* next;
};

struct Node* head = NULL;
struct Node* tail = NULL;
struct Node* next = NULL; // Used to iterate over the list without changing it.

int simple_list_has_next() {
	return next ? 1 : 0;
}

char* simple_list_get_next() {
	struct Node* tmp = next;
	if (tmp) {
		next = tmp->next;
	}
	return tmp->data;
}

void simple_list_reset() {
	next = head;
}

int simple_list_add(const char* str) {
	struct Node* new_node = malloc(sizeof(struct Node));
	char* data = strdup(str);
	if (!new_node || !data) {
		log_error("Error while allocating memory for new node in queue");
		return QUEUE_ALLOC_ERROR;
	}
	new_node->data = data;
	new_node->next = NULL;

	if (tail == NULL) {
		head = new_node;
		tail = new_node;
	} else {
		tail->next = new_node; // (old tail->next was NULL and needs to point to the newest Node*)
		tail = new_node; // new tail->next points to NULL again
	}

	next = head; // pushing an element always resets the 'next' pointer to head

	return QUEUE_OKAY;
}

void simple_list_print() {
	struct Node* tmp = head;
	if (!tmp) {
		log_error("Simple list is empty");
	}
	while (tmp != NULL) {
		log_trace("data: %s", tmp->data);
		tmp = tmp->next;
	}
}

char* simple_list_peek_back() {
	if (tail) {
		return tail->data;
	} else {
		return NULL;
	}
}

char* simple_list_peek_front() {
	if (head) {
		return head->data;
	} else {
		return NULL;
	}
}

int simple_list_is_empty() {
	return head ? 0 : 1;
}

void simple_list_clean() {
	struct Node* tmp = head;
	while (tmp != NULL) {
		struct Node* next = tmp->next;
		if (tmp->data) {
			free(tmp->data);
		}
		free(tmp);

		tmp = next;
	}
	head = NULL;
	tail = NULL;
	next = NULL;
}

int simple_list_size() {
	int count = 0;
	struct Node* tmp = head;
	while (tmp != NULL) {
		count++;
		tmp = tmp->next;
	}
	return count;
}
