#ifdef __cplusplus
extern "C" {
#endif

#ifndef TGPRO_ENVIRONMENT_H
#define TGPRO_ENVIRONMENT_H

#include <wchar.h>
#if defined(WIN32) || defined(WIN64)
#include <windows.h>
#endif /* defined(WIN32) || defined(WIN64) */

#ifndef BUFFER_SIZE
#define BUFFER_SIZE 4096
#endif /* BUFFER_SIZE */

/* Place of SumatraPDF in %TGPRO_INSTALLPATH%. */
#define SUMATRAPDF_EXE_SUBDIR "\\Scripte\\SumatraPDF.exe"
#define SUMATRAPDF_EXE "SumatraPDF.exe"
/* Place of PuTTY in %TGPRO_INSTALLPATH%. */
#define PUTTY_EXE_SUBDIR "\\putty.exe"
#define PUTTY_EXE "putty.exe"
/* Parameters for SumatraPDF. */
#define SUMATRA_PARAMS "-print-dialog -exit-on-print"
#define SUMATRA_QUICK_PRINT_PARAMS "-exit-on-print -print-to-default"
/* Place of WinSCP.com in %TGPRO_INSTALLPATH%. */
#define WINSCP_COM_SUBDIR_SPOOL "\\Spool\\WinSCP.com"
#define WINSCP_COM_SUBDIR_TRANSFER "\\WinSCP.com"
/* Name of WinSCP COM executable. */
#define WINSCP_COM "WinSCP.com"
/* Name of WinSCP executabele. */
#define WINSCP_EXE "WinSCP.exe"
#define WINSCP_EXE_SUBDIR "\\Spool\\WinSCP.exe"
/* Place of the WinSCP spool config file in %APPDATA%. */
#define SPOOL_INI_SUBDIR "\\vnc\\spool.ini"
#define SPOOL_INI "spool.ini"
/* Place of the WinSCP Schleuse config file in %APPDATA%. */
#define TRANSFER_INI_SUBDIR "\\vnc\\transfer.ini"
#define TRANSFER_INI "transfer.ini"
/* Place of TG-Pro config file in %TGPRO_INSTALLPATH%. */
#define TGPRO_CFG_SUBDIR "\\tgpro.cfg"
#define TGPRO_CFG "tgpro.cfg"
#define TGPRO_VNC_SUBDIR "\\vnc\\tgpro.vnc"
#define TGPRO_VNC "tgpro.vnc"
/* Name of the subdir we create in %TEMP%. */
#define TGPRO_TEMP_SUBDIR "tgprotemp"
/* Name of WinSCP's connection to the TG-Pro server. */
#define TGPRO_CONNECTION "tgpro"
/* */
#define PUTTY_CFG_SUBDIR "\\TGProPuttyData"
/* */
#define PUTTY_SESSIONS_SUBDIR "\\sessions"
/* */
#define PUTTY_SETTINGS_FILE "\\Default%20Settings"
/* */
#define TGPRO_SUBDIR "TightGate-Pro"
#define TGSELECTOR_SUBDIR "TightGate-Selector"
/* */
#define URL_WHITELIST_FILENAME "url_whitelist.txt"
#define URL_WHITELIST_FILENAME2 "url whitelist.txt"
#define BROWSERCHOICE_EXE "Browserchoice.exe"
#define SCHLEUSE_EXE "Schleuse.exe"
#define VNCVIEWER_EXE "vncviewer.exe"
/* TG-Mobile WinSCP Schleuse config file subdir */
#define TGMOBILE_TRANSFER_INI_SUBDIR "\\TG-Mobile\\SSOCerts\\transfer.ini"
#define TGMOBILE_VNC_CFG_SUBDIR "\\TG-Mobile\\SSOCerts\\tgpro.vnc"
#define TGMOBILE_COMMAND_LINE_ARG "-mobile"

#define BROWSERCHOICE_CFG_SUBDIR "\\browserchoice.cfg"
#define BROWSERCHOICE_CFG "browserchoice.cfg"

#define MAGICURL_PIPE "\\\\.\\pipe\\magicurl-pipe"
#define MAGIC_URL_PIPE_NAME_FILE_NAME "\\magicurl_pipename"

#define VNCVIEWER_LOG_FILE_NAME "\\vncviewer.log"
#define VNCVIEWER_TRACE_FILE_NAME "\\vncviewer-trace.log"
#define VNCVIEWER_INSTREAM_TRACE_FILE_NAME "\\vncviewer-instream-trace.log"
#define VNCVIEWER_OUTSTREAM_TRACE_FILE_NAME "\\vncviewer-outstream-trace.log"

	struct url_match_t {
		char* url_expr;
		char* dest; // 'local' or 'remote'
		char* browser; // only accepts 'firefox' (or just forces it)
		char* browser_profile;
	};

	char* url_semi_encode(const char* url);
	void set_error_box_title(wchar_t* new_error_box_title);
	void error_check(const int error_case, const wchar_t* error_text);
	char* str_trim(char* text_line);
	int dir_exists(const char *path);
	int file_exists(const char* filename);
	int check_pdf(const char* file_name);
	void print_pdf(const char* pdf_file);
	int adobe_print_pdf(const char* pdf_file);
	char* get_host_name();
	char* get_krb_host_name();
	int uses_sso_ad_authentication();
	int uses_plain_authentication();
	int launch_program(char* prog_cmd, const int show_window, const int bring_to_front, const int wait_for_child, const char* working_dir);
	void kill_process(int pid);
	void exit_tgpro_environment();
	void set_quick_print(int new_qp);
	const char* get_tgpro_tmp_path();
	const char* get_winscp_exe_path();
	const char* get_winscp_com_path_spool();
	const char* get_winscp_com_path_transfer();
	const char* get_appdata_path();
	const char* get_appdata(int create_vnc_subdir);
	const char* get_tgpro_path();
	const char* get_tgselector_path();
	const char* get_user_name();
	char* get_current_session_id();
	const char* get_putty_exe_path();
	const char* get_putty_settings_file();
	const char* get_putty_cfg_path();
	const char* get_tgpro_cfg_path();
	const char* get_tgpro_vnc_path();
	const char* get_browserchoice_cfg_path();
	size_t copy_start_path(char* start_path, size_t max_len);
	const char* get_start_path();
	char* file_exists_in_path(const char* path_1, const char* path_2);
	struct url_match_t* is_in_any_default_url_whitelist(const char* url, const char* viewer_config_dir); // This one does exactly the same as is_in_url_whitelist but it is clearer, that it looks all over the default places
	struct url_match_t* is_in_specific_url_whitelist(const char* url, const char* whitelist_file);
	int check_running(const char* prog_name);
	const char* get_browserchoice_exe_path();
	const char* get_schleuse_exe_path();
	const char* get_vncviewer_exe_path();
	char* get_tgpro_cfg_value(const char* key);
	char* get_cfg_value_from_file(const char* key, const char* cfg_file);
	char* get_tgpro_cfg_value_from_file(const char* key, const char* cfg_file);
	/* Returns a char* containing the path to a URL whitelist in the 'system dir' (a.k.a. where the viewer is isntalled). Please remember to free it after use */
	char* get_url_whitelist_path_system();
	/* Returns a char* containing the path to a URL whitelist in the vnc dir. Please remember to free it after use */
	char* get_url_whitelist_path_user();
	/* Returns a char* containing the path to a URL whitelist 'next' to the viewer. Please remember to free it after use */
	char* get_url_whitelist_path_startpath();
	/* Returns a char* containing the path to a URL whitelist in the viewer's configdir. Please remember to free it after use */
	char* get_url_whitelist_path_viewer_config_dir(const char* viewer_config_dir);
#if defined(WIN32) || defined(WIN64)
	DWORD get_process_id(const char* prog_name);
	DWORD get_process_id_for_user(const char* prog_name, const char* username);
	unsigned int count_processes_for_user(const char* processname, const char* username);
	void bring_window_to_front();
	void bring_viewer_window_to_front();
	HWND get_viewer_main_window_handle(const DWORD process_id, const unsigned int force_reload);
	void log_tgpro_environment();
	void log_version(const char* path_to_exe);
	/**
	 * Creates an LNK Windows shortcut in the user's shell:sendto.
	 */
	int create_send_to_shortcut(const char* config_dir, const char* description);
#else
	int get_process_id_for_user(const char* process_name, const char* username); // actually does a pgrep so it matches incomplete process names
	int symlink_exists(const char* path);
#endif /* defined(WIN32) || defined(WIN64) */

/**
 * Read configdir from command line if given. Returns a NULL if -configdir is not specified
 * Does not return the surrounding quotes but ALWAYS adds a trailing backslash!
 * Warning! The string has to be freed at the end (match allocates memory!)
 */
	char* get_config_dir_parameter(char* command_line);
/**
 * Read vncviewer from command line if given. Returns a NULL if -vncviewer is not specified
 * Does not return the surrounding quotes but ALWAYS adds a trailing backslash!
 * Warning! The string has to be freed at the end (match allocates memory!)
 */
	char* get_vncviewer_parameter(char* command_line);

#if defined(WIN32) || defined(WIN64)
/**
 * Get currently running exe (only for windows)
 * Warning! The string has to be freed after use.
 */
	wchar_t* get_running_exe();
#endif /* defined(WIN32) || defined(WIN64) */

#if defined(WIN32) || defined(WIN64)
/**
 * Get filename where the magicurl named pipe name for this user is stored
 * in the user's %temp% directory.
 * Warning! The string has to be freed after use (alternatively, you
 * can call exit_tgpro_environment() when you're done)
 */
	char* get_tmp_magicurl_pipe_name_file_path();
#endif /* defined(WIN32) || defined(WIN64) */

/**
 * Get filename in the user's %temp% directory where the vncviewer log will
 * be saved if log to file option is used.
 * Warning! The string has to be freed after use (alternatively, you
 * can call exit_tgpro_environment() when you're done)
 */
	char* get_viewer_log_file_path();

/**
 * Get filename in the user's %temp% directory where the vncviewer trace will
 * be written to if the viewer crashes.
 * Warning! The string has to be freed after use (alternatively, you
 * can call exit_tgpro_environment() when you're done)
 */
	char* get_viewer_trace_file_path();

/**
 * Get filename in the user's %temp% directory where the vncviewer instream
 * trace will be saved.
 * Warning! The string has to be freed after use (alternatively, you
 * can call exit_tgpro_environment() when you're done)
 */
	char* get_viewer_instream_trace_file_path();

/**
 * Get filename in the user's %temp% directory where the vncviewer outstream
 * trace will be saved.
 * Warning! The string has to be freed after use (alternatively, you
 * can call exit_tgpro_environment() when you're done)
 */
	char* get_viewer_outstream_trace_file_path();


/**
 * Initializes a file logger. Mostly for Windows, as it's practically
 * impossible to see stdout. Always writes to %tmp% or /tmp.
 *
 * The filename parameter cannot include the path.
 *
 * The log_level parameter can be one of these values (see loglib/log.h):
 * LOG_TRACE, LOG_DEBUG, LOG_INFO, LOG_WARN, LOG_ERROR, LOG_FATAL
 */
	int log_to_file_init(const char* filename, const int log_level);
#endif /* TGPRO_ENVIRONMENT_H */

#ifdef __cplusplus
}
#endif
