#ifdef __cplusplus
extern "C" {
#endif

#ifndef WINSCP_INI_HANDLER_H
#define WINSCP_INI_HANDLER_H


#define WINSCP_INI_TYPE_TRANSFER 0
#define WINSCP_INI_TYPE_SPOOL 1

void set_winscp_remote_directory(const char* ini_file, const int ini_type, char* section);
void generate_winscp_ini(const char* ini_file_path, const int ini_type);
void generate_winscp_ini_defaultpath(const int ini_type);
char* get_winscp_ini_value(const char* ini_file_path, const char* section, const char* key);
void set_winscp_ini_value(const char* ini_file_path, const char* section, const char* key, const char* value);
void set_winscp_ini_user_name(const char* ini_file);
void delete_winscp_ini_key(const char* ini_file_path, const char* delete_key);
char* get_winscp_remote_directory(const char* ini_file, const int ini_type, char* section);


#endif /* WINSCP_INI_HANDLER_H */

#ifdef __cplusplus
}
#endif
