/*
 * RSBAC REG decision module for RBAC model - Headers
 *
 * Author and (c) 1999-2009 Amon Ott <ao@rsbac.org>
 * Last change: 20/Jan/2009
 */

#ifndef RBAC_H
#define RBAC_H

#define RBAC_NAMELEN 24

/* Max role inheritance level */
#define MAXINHERIT 10

struct rbac_role_entry_t {
	__u32 parent;
	char name[RBAC_NAMELEN];
	rsbac_request_vector_t fd_rights;
};

struct rbac_sys_list_roles_arg {
	__u32 * role_array;
	u_int   maxnum;
};

struct rbac_sys_get_role_arg {
	__u32   role;
	struct rbac_role_entry_t * entry_p;
};

struct rbac_sys_set_role_arg {
	__u32   role;
	struct rbac_role_entry_t entry;
};

#define RBAC_sys_base 1000
#define RBAC_sys_list_roles RBAC_sys_base
#define RBAC_sys_list_roles_name "RBAC list_roles"

#define RBAC_sys_get_role (RBAC_sys_base + 1)
#define RBAC_sys_get_role_name "RBAC get_role"

#define RBAC_sys_set_role (RBAC_sys_base + 2)
#define RBAC_sys_set_role_name "RBAC set_role"

#define RBAC_sys_del_role (RBAC_sys_base + 3)
#define RBAC_sys_del_role_name "RBAC del_role"

#endif
