/*************************************************** */
/* Rule Set Based Access Control                     */
/*                                                   */
/* Author and (c) 1999-2010: Amon Ott <ao@rsbac.org> */
/*                                                   */
/* Last modified: 25/Jan/2010                        */
/*************************************************** */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <rsbac/types.h>
#include <rsbac/aci_data_structures.h>
#include <rsbac/getname.h>
#include <rsbac/syscalls.h>
#include <rsbac/error.h>
#include <rsbac/helpers.h>
#include "nls.h"
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

char * progname;

void use(void)
    {
      printf(gettext("%s (RSBAC %s)\n***\n"), progname, VERSION);
      printf(gettext("Use: %s [flags] target-type file/dirname\n"), progname);  
      printf(gettext(" -h = this help, -- = no more flags,\n"));
      printf(gettext(" -d = numeric device specification ({b|c}major[:minor])\n"));
      printf(gettext(" -N ta = transaction number (default = value of RSBAC_TA, if set, or 0)\n"));
      printf(gettext(" target-type = FILE, DIR, FIFO, SYMLINK or DEV\n"));
    }

int main(int argc, char ** argv)
{
  int res = 0;
  char tmp1[80];
  enum rsbac_target_t target;
  rsbac_list_ta_number_t ta_number = 0;
  int numdev = 0;
  u_int stopflags = FALSE;

  progname = argv[0];
  locale_init();
  
  {
    char * env = getenv("RSBAC_TA");

    if(env)
      ta_number = strtoul(env,0,0);
  }
  while((argc > 1) && (argv[1][0] == '-') && !stopflags)
    {
      char * pos = argv[1];
      pos++;
      while(*pos)
        {
          switch(*pos)
            {
              case '-':
                stopflags = TRUE;
                break;
              case 'h':
                use();
                return 0;
              case 'd':
                numdev=1;
                break;
              case 'N':
                if(argc > 2)
                  {
                    ta_number = strtoul(argv[2], 0, 10);
                    argc--;
                    argv++;
                  }
                else
                  {
                    fprintf(stderr, gettext("%s: missing transaction number value for parameter %c\n"), progname, *pos);
                    exit(1);
                  }
                break;
              default:
                fprintf(stderr, gettext("%s: unknown parameter %c\n"), progname, *pos);
                exit(1);
            }
          pos++;
        }
      argv++;
      argc--;
    }

  if (argc == 3)
    {
      target = get_target_nr(argv[1]);
      if(numdev)
        {
          union rsbac_target_id_t tid;

          error_exit(strtodevdesc(argv[2], &tid.dev));
          res = rsbac_remove_target(ta_number, target, &tid);
        }
      else
        res = rsbac_remove_target_n(ta_number, target, argv[2]);
      if(res)
        {
          get_error_name(tmp1,res);
          fprintf(stderr, gettext("%s: error: %s\n"), argv[0], tmp1);
          exit(1);
        }
      exit(0);
    }
  else
    {
      use();
    }
  exit(1);
}
