/*************************************************** */
/* Rule Set Based Access Control                     */
/*                                                   */
/* Author and (c) 1999-2010: Amon Ott <ao@rsbac.org> */
/*                                                   */
/* Last modified: 25/Jan/2010                        */
/*************************************************** */

#include <stdio.h>
#include <stdlib.h>
#include <rsbac/types.h>
#include <rsbac/syscalls.h>
#include <rsbac/error.h>
#include <rsbac/getname.h>
#include "nls.h"

char * progname;

void use(void)
    {
      printf(gettext("%s (RSBAC %s)\n***\n"), progname, VERSION);
      printf(gettext("Use: %s [flags]\n"), progname);
      printf(gettext("This program shows the current RC role\n"));
      printf(gettext(" -h = this help, -- = no more flags,\n"));
      printf(gettext("-s = script mode\n"));
      printf(gettext("-h = this help\n"));
    }

int main(int argc, char ** argv)
{
  int res = 0;
  int script = 0;
  rsbac_rc_role_id_t role;
  u_int stopflags = FALSE;

  locale_init();

  progname = argv[0];
  while((argc > 1) && (argv[1][0] == '-') && !stopflags)
    {
      char * pos = argv[1];
      pos++;
      while(*pos)
        {
          switch(*pos)
            {
              case '-':
                stopflags = TRUE;
                break;
              case 'h':
                use();
                return 0;
              case 's':
                script = 1;
                break;
              default:
                fprintf(stderr, gettext("%s: unknown parameter %c\n"), progname, *pos);
                exit(1);
            }
          pos++;
        }
      argv++;
      argc--;
    }
  res = rsbac_rc_get_current_role(&role);
  error_exit(res);
  if(script)
    printf("%u\n", role);
  else
    printf(gettext("%s: current role is %u\n"), argv[0], role);
    
  return 0;
}
