/* Copyright 2014 Lew Palm <l.palm@m-privacy.de> for m-privacy GmbH
 *
 * This is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this software; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307,
 * USA.
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <rfb/LogWriter.h>

#include <FL/Fl.H>
#include <FL/fl_draw.H>
#include <FL/Fl_Box.H>

#include "ConnectingMessage.h"
#include "i18n.h"

static rfb::LogWriter vlog("ConnectingMessage");

ConnectingMessage::ConnectingMessage(const char* window_title, const char* server_name, const char* server_type)
	: Fl_Window(500, 70, window_title) {
	border(0);
	const int box_margin = 8;
	int box_width =  w() - box_margin * 2;
	int box_height = h() - box_margin * 2;
	if (server_type)
		snprintf(connection_msg, MAX_MSG_LEN - 1, _("Connecting to %s"), server_type);
	else
		snprintf(connection_msg, MAX_MSG_LEN - 1, _("Connecting"));
	connection_msg[MAX_MSG_LEN - 1] = '\0';
	strcat(connection_msg, "…");
	Fl_Box *box = new Fl_Box(box_margin, box_margin, box_width, box_height, connection_msg);
	box->box(FL_UP_BOX);
	box_width = box->labelsize() * (13 + strlen(server_type)) * 0.6 + box_margin * 2;
	box_height = box->labelsize() + box_margin * 2;
	box->resize(box_margin, box_margin, box_width, box_height);
	int new_ww = box_width + box_margin * 2;
	int new_wh = box_height + box_margin * 2;
	resize(Fl::w() / 2 - new_ww / 2,
	       Fl::h() / 2 - new_wh / 2,
	       new_ww, new_wh);
	set_modal();
	end();
}


ConnectingMessage::~ConnectingMessage() {
	hide();
}
