/* Copyright (C) 2000-2003 Constantin Kaplinsky.  All Rights Reserved.
 * Copyright (C) 2004-2005 Cendio AB. All rights reserved.
 * Copyright (C) 2011 D. R. Commander.  All Rights Reserved.
 * Copyright (C) 2021-2024 m-privacy GmbH.  All Rights Reserved.
 * 
 * This is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this software; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307,
 * USA.
 */

//
// MPDecompressor decompresses a MP image into RGB output into
// an underlying MemOutStream
//

#ifndef __RFB_MPDECOMPRESSOR_H__
#define __RFB_MPDECOMPRESSOR_H__

#include <rfb/PixelFormat.h>
#include <rfb/Rect.h>

#include <rfb/MP.h>

#if !defined(__APPLE__)
#include <jxl/decode.h>
#ifndef WIN32
#include <jxl/resizable_parallel_runner.h>
#endif
#endif

struct jpeg_decompress_struct;

struct MP_JPEG_ERROR_MGR;
struct MP_JPEG_SRC_MGR;

#define MPDECOMPRESSNUM 4

namespace rfb {

	class MPDecompressor {

	public:

		MPDecompressor(size_t threadNum);
		~MPDecompressor();

		void decompress(const rdr::U8 *, int, rdr::U8 *, int, const Rect&,
				const PixelFormat&);

		static unsigned compressionCount[MP_COMPRESSION_MAX+1];

	private:
#if !defined(__APPLE__)
		JxlDecoder* jpegxlDecoder;
#ifndef WIN32
		void* jpegxlRunner;
#endif
#endif
		size_t threadNum;
		unsigned compressionCountLocal[MP_COMPRESSION_MAX+1];
		rdr::U64 totalBytes[MP_COMPRESSION_MAX+1];
		rdr::U64 totalCBytes[MP_COMPRESSION_MAX+1];
		int minCompressed[MP_COMPRESSION_MAX+1];
		int maxCompressed[MP_COMPRESSION_MAX+1];
	};

} // end of namespace rfb

#endif
