/* Copyright 2017-2019 m-privacy GmbH.
 *
 * This is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this software; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307,
 * USA.
 */

#ifndef __CAUTOTRANSFER_HANDLER_H__
#define __CAUTOTRANSFER_HANDLER_H__

#include <rdr/mutex.h>
#include <queue>

class CAutotransferHandler {
	public:
		~CAutotransferHandler();

		static bool initCorrect;
		static char* autotransferTmpDir;
		static char* autotransferDirFromServer; // This overrides the local autotrasnferFolder parameter if set in the vnc options
		static MUTEX_TYPE processingQueueLock;
		static std::queue<char*> processingQueue;

		static void init();
		static void destroy();
		static void handle(char* path);
		static void addToProcessingQueue(char* filename);

	private:
		static char* autotransferDir;
		static bool createAutotransferDir();
};

#endif /* __CAUTOTRANSFER_HANDLER_H__ */
