/* Copyright (C) 2005 Martin Koegler
 * Copyright (C) 2010 TigerVNC Team
 * Copyright (C) 2012-2018 m-privacy
 * 
 * This is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this software; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307,
 * USA.
 */
#ifndef __RFB_CSECURITYKRB_H__
#define __RFB_CSECURITYKRB_H__

#include <rfb/CSecurity.h>
#include <rfb/Security.h>

#include <gsasl.h>

namespace rfb {

  class CSecurityKrb : public CSecurity {
  public:
    CSecurityKrb(CConnection* cc);
    ~CSecurityKrb();
    virtual bool processMsg();
    virtual unsigned int getType() const { return secTypeX509Krb; }
    virtual const char* description() const { return "authenticate with Kerberos tickets"; }
    static StringParameter KrbAuthid;
    static StringParameter KrbService;
    static StringParameter KrbHostname;

  private:
    Gsasl *gsasl_ctx;
    Gsasl_session *gsasl_session;
    unsigned int state;
    size_t maxbuflen, buflen;
    char * buf;
    int rc;
  };
}
#endif
