/* Copyright (C) 2002-2005 Realvnc Ltd.  All Rights Reserved.
 * Copyright 2011 Pierre Ossman for Cendio AB
 * Copyright 2015-2024 m-privacy GmbH, Berlin
 * 
 * This is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this software; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307,
 * USA.
 */

//
// FdOutStream streams to a file descriptor.
//

#ifndef __RDR_FDOUTSTREAM_H__
#define __RDR_FDOUTSTREAM_H__

#include <sys/time.h>

#include <rdr/OutStream.h>

namespace rdr {

  class FdOutStream : public OutStream {

  public:

    FdOutStream(int fd);
    virtual ~FdOutStream();

    int getFd() { return fd; }
    virtual void cork(bool enable, int key=0, QPrio prio=QPRIOMEDIUM);

    virtual int bufferUsage(int key=0, QPrio prio=QPRIOMEDIUM) { return (queueEmpty(prio) || flushActive) ? 0 : 1; }

    void flush(int key=0, QPrio prio=QPRIOMEDIUM, bool wait=false);

  protected:
    static THREAD_FUNC flushThread(void* param);
    THREAD_ID flushThreadId;
    static TGVNC_CONDITION_TYPE buffersAvailableCondition;
    static MUTEX_TYPE buffersAvailableConditionLock;
    static TGVNC_CONDITION_TYPE flushedCondition[QPRIONUM];
    static MUTEX_TYPE flushedConditionLock[QPRIONUM];

  private:
    size_t writeWithTimeout(const void* data, size_t length, int timeoutms);
    int fd;
    bool blocking;
    int timeoutms;
    U32 bufferStats[MAXBUFFERSIZE];
    U64 flushCalls;
    bool flushActive;
  };

}

#endif
