/* Copyright 2021 m-privacy GmbH.
 *
 * This is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this software; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307,
 * USA.
 */

#ifndef __SAUTOTRANSFER_OPSWAT_H__
#define __SAUTOTRANSFER_OPSWAT_H__

#ifndef WIN32

#include <curl/curl.h>
#include <string>

#include <rfb/SAutotransferDirWatcher.h>

using namespace std;

class SAutotransferOpswat: public SAutotransferDirWatcher
{
public:
	SAutotransferOpswat();
	const char* getDirToWatch() override;
	string getFileAnalyzeResultJson(const string dataId);
	//	size_t writeCallback(void *contents, size_t size, size_t nmemb, void *userp);
	//	size_t readCallback(char *ptr, size_t size, size_t nmemb, void *userdata);
	CURLcode getSanitizedFile(const string dataId, const string outputFile);
	void processFile(char* filename) override;
	string uploadFile(const char* uploadthis);
	const char* getRule();
	const char* getBaseUrl();
private:
	char userAgent[256];
	const char* CA_CERTS_FILE;
	const char* rule;
	char* baseUrl;
};

#endif /* ifndef WIN32 */
#endif /* __SAUTOTRANSFER_OPSWAT_H__ */
