/* 
 * Copyright (C) 2021 m-privacy GmbH. All Rights Reserved.
 * 
 * This is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this software; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307,
 * USA.
 */

#ifndef __RFB_WinErrors_H__
#define __RFB_WinErrors_H__

#if defined(WIN32)
static inline const char * WinErrorName(int number)
{
	switch(number) {
		case WSA_INVALID_HANDLE:
			return "INVALID_HANDLE";
		case WSA_NOT_ENOUGH_MEMORY:
			return "NOT_ENOUGH_MEMORY";
		case WSA_INVALID_PARAMETER:
			return "INVALID_PARAMETER";
		case WSA_OPERATION_ABORTED:
			return "OPERATION_ABORTED";
		case WSA_IO_INCOMPLETE:
			return "IO_INCOMPLETE";
		case WSA_IO_PENDING:
			return "IO_PENDING";
		case WSAEINTR:
			return "EINTR";
		case WSAEBADF:
			return "EBADF";
		case WSAEACCES:
			return "EACCES";
		case WSAEFAULT:
			return "EFAULT";
		case WSAEINVAL:
			return "WSAEINVAL";
		case WSAEMFILE:
			return "EMFILE";
		case WSAEWOULDBLOCK:
			return "EWOULDBLOCK";
		case WSAEINPROGRESS:
			return "EINPROGRESS";
		case WSAEALREADY:
			return "EALREADY";
		case WSAENOTSOCK:
			return "ENOTSOCK";
		case 10039:
			return "EDERELIDRREQ";
		case WSAEMSGSIZE:
			return "EMSGSIZE";
		case WSAEPROTOTYPE:
			return "EPROTOTYPE";
		case WSAENOPROTOOPT:
			return "ENOPROTOOPT";
		case WSAEPROTONOSUPPORT:
			return "EPROTONOSUPPORT";
		case WSAESOCKTNOSUPPORT:
			return "ESOCKTNOSUPPORT";
		case WSAEOPNOTSUPP:
			return "EOPNOTSUPP";
		case WSAEPFNOSUPPORT:
			return "EPFNOSUPPORT";
		case WSAEAFNOSUPPORT:
			return "EAFNOSUPPORT";
		case WSAEADDRINUSE:
			return "EADDRINUSE";
		case WSAEADDRNOTAVAIL:
			return "EADDRNOTAVAIL";
		case WSAENETDOWN:
			return "ENETDOWN";
		case WSAENETUNREACH:
			return "ENETUNREACH";
		case WSAENETRESET:
			return "ENETRESET";
		case WSAECONNABORTED:
			return "ECONNABORTED";
		case WSAECONNRESET:
			return "ECONNRESET";
		case WSAENOBUFS:
			return "ENOBUFS";
		case WSAEISCONN:
			return "EISCONN";
		case WSAENOTCONN:
			return "ENOTCONN";
		case WSAESHUTDOWN:
			return "ESHUTDOWN";
		case WSAETOOMANYREFS:
			return "ETOOMANYREFS";
		case WSAETIMEDOUT:
			return "ETIMEDOUT";
		case WSAECONNREFUSED:
			return "ECONNREFUSED";
		case WSAELOOP:
			return "ELOOP";
		case WSAENAMETOOLONG:
			return "ENAMETOOLONG";
		case WSAEHOSTDOWN:
			return "EHOSTDOWN";
		case WSAEHOSTUNREACH:
			return "EHOSTUNREACH";
		case WSAENOTEMPTY:
			return "ENOTEMPTY";
		case WSAEPROCLIM:
			return "EPROCLIM";
		case WSAEUSERS:
			return "EUSERS";
		case WSAEDQUOT:
			return "EDQUOT";
		case WSAESTALE:
			return "ESTALE";
		case WSAEREMOTE:
			return "EREMOTE";
		case WSASYSNOTREADY:
			return "SYSNOTREADY";
		case WSAVERNOTSUPPORTED:
			return "VERNOTSUPPORTED";
		case WSANOTINITIALISED:
			return "NOTINITIALISED";
		case WSAEDISCON:
			return "EDISCON";
		case WSAENOMORE:
			return "ENOMORE";
		case WSAECANCELLED:
			return "ECANCELLED";
		case WSAEINVALIDPROCTABLE:
			return "EINVALIDPROCTABLE";
		case WSAEINVALIDPROVIDER:
			return "EINVALIDPROVIDER";
		case WSAEPROVIDERFAILEDINIT:
			return "EPROVIDERFAILEDINIT";
		case WSASYSCALLFAILURE:
			return "SYSCALLFAILURE";
		case WSASERVICE_NOT_FOUND:
			return "SERVICE_NOT_FOUND";
		case WSATYPE_NOT_FOUND:
			return "TYPE_NOT_FOUND";
		case WSA_E_NO_MORE:
			return "E_NO_MORE";
		case WSA_E_CANCELLED:
			return "E_CANCELLED";
		case WSAEREFUSED:
			return "EREFUSED";
		case WSAHOST_NOT_FOUND:
			return "HOST_NOT_FOUND";
		case WSATRY_AGAIN:
			return "TRY_AGAIN";
		case WSANO_RECOVERY:
			return "NO_RECOVERY";
		case WSANO_DATA:
			return "NO_DATA";
		default:
			return "Unknown";
	}
}
#endif

#endif
