/* Copyright 2024 m-privacy GmbH.
 *
 * This is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this software; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307,
 * USA.
 */

#ifndef __NORMAL_ENTER_DIALOG_H__
#define __NORMAL_ENTER_DIALOG_H__

#include <FL/Fl_Window.H>

/**
 * Dialog where the enter key works as everybody expects i.e. "clicking" the
 * focused button.
 */
class NormalEnterDialog : public Fl_Window {
public:
	NormalEnterDialog(int w, int h, const char* title) : Fl_Window(w, h, title) {}

	int handle(int event) override {
		switch (event) {
		case FL_SHORTCUT:
			if (Fl::event_key() == FL_Enter || Fl::event_key() == FL_KP_Enter) {
				if (Fl::focus() && Fl::focus()->callback()) {
					Fl::focus()->do_callback();
				}
				return 1; // handled the event
			}
			break;
		default:
			break;
		}

		return Fl_Window::handle(event);
	}
};

#endif /* ifndef __NORMAL_ENTER_DIALOG_H__ */
