/**
 * Before including this file you have to define the mplog preprocessor macro or it
 * will just log using printf's.
 *
 * I know, I really shouldn't define stuff in a header file. It's just this is the best idea
 * we had to use functions in the VNC and SSH servers *and* have the great advantage of 
 * logging stuff.
 *
 */

#include <gio/gio.h>
#include <sys/stat.h>

#ifndef mplog_info
#define mplog_info(...) printf(__VA_ARGS__); printf("\n");
#endif

#ifndef mplog_debug
#define mplog_debug(...) printf(__VA_ARGS__); printf("\n");
#endif

#ifndef mplog_debug2
#define mplog_debug2(...) mplog_debug(__VA_ARGS__);
#endif

#ifndef mplog_debug3
#define mplog_debug3(...) mplog_debug(__VA_ARGS__);
#endif

#ifndef mplog_verbose
#define mplog_verbose(...) mplog_debug(__VA_ARGS__);
#endif

#ifndef mplog_error
#define mplog_error(...) printf(__VA_ARGS__); printf("\n");
#endif

#ifndef mplog_syslog_info
#define mplog_syslog_info(...) printf(__VA_ARGS__); printf("\n");
#endif

#define BUFFER_SIZE 4096

static int get_mime_type_glib(const char* path, char (*mime_type)[BUFFER_SIZE])
{
	char* result = *mime_type;
	memset(result, 0, BUFFER_SIZE);

	if (*mime_type == NULL) {
		return 0;
	}

	struct stat st;
	if (lstat(path, &st) == -1) {
		return 0;
	}

	if (st.st_size == 0) { // Manual hack to make backwards-compatible with our programs
		strncpy(result, "inode/x-empty", BUFFER_SIZE - 1);
	} else if(S_ISLNK(st.st_mode)) {
		strncpy(result, "inode/symlink", BUFFER_SIZE - 1);
	} else {
		GError* gerror = NULL;
		GFile* gfile = g_file_new_for_path(path);
		GFileInfo* gfile_info = g_file_query_info(gfile, "standard::*", (GFileQueryInfoFlags) 0, NULL, &gerror);
		if (gerror != NULL) {
			mplog_error("Error while checking mime type: %s", gerror->message);
			g_clear_error(&gerror);
		}
		const char* content_type = g_file_info_get_content_type(gfile_info);
		if (!content_type || !*content_type) {
			return 0;
		}
		strncpy(result, content_type, BUFFER_SIZE - 1);
	}

	result[BUFFER_SIZE - 1] = 0;

	return 1;
}
