#ifndef MP_SIMPLE_LIST_H
#define MP_SIMPLE_LIST_H

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

/*
 * Extremely simple implementation of a FIFO linked list for char*s which basically allows to
 * iterate over it in a very simple manner:
 *
 * while (has_next) {
 *     next = get_next;
 *     do_something(next);
 * }
 *
 * If you need to iterate over the list again, just use the reset() function.
 * add()ing a new element also resets the 'next' marker.
 *
 * It allocates everything in the heap. After use, it must be cleaned with clean().
 */

#define QUEUE_OKAY 0
#define QUEUE_ALLOC_ERROR 100

int simple_list_add(const char* str);

int simple_list_has_next();
char* simple_list_get_next();
void simple_list_reset();

void simple_list_clean();

char* simple_list_peek_back();
char* simple_list_peek_front();

int simple_list_is_empty();

void simple_list_print();

int simple_list_size();

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* MP_SIMPLE_LIST_H */
