#if !defined(WIN32) && !defined(WIN64) && !defined(__APPLE__)

#include <limits.h>
#include <pwd.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <sys/types.h>
#include <unistd.h>

#include <rsbac/types.h>
#include <rsbac/syscall_rsbac.h>

#include "log.h"
#include "transfer_log_helpers.h"


#if !defined(WIN32) && !defined(WIN64) && !defined(__APPLE__) && !defined(rsbac_get_attr)
int rsbac_get_attr(rsbac_list_ta_number_t ta_number,
		enum rsbac_switch_target_t module,
		enum rsbac_target_t target,
		union rsbac_target_id_t * tid,
		enum rsbac_attribute_t attr,
		union rsbac_attribute_value_t * value,
		int inherit) {
	union rsbac_syscall_arg_t arg;

	arg.get_attr.ta_number = ta_number;
	arg.get_attr.module = module;
	arg.get_attr.target = target;
	arg.get_attr.tid = tid;
	arg.get_attr.attr = attr;
	arg.get_attr.value = value;
	arg.get_attr.inherit = inherit;
	return sys_rsbac(RSBAC_API_VERSION_NR, RSYS_get_attr, &arg);
}
#endif


char* resolve_username_for_logs(void)
{
	struct passwd* pw = getpwuid(geteuid());
	if (!pw) {
		log_error("%s: Failed to get username with pw", __func__);
		return NULL;
	}

	char* username = (char*) malloc(LOGIN_NAME_MAX);
	if (!username) {
		log_error("%s: Failed to allocate memory for username", __func__);
		return NULL;
	}
	username[0] = '\0';

	char line[1024];

	// Anonymous logging?
	FILE* fp = fopen("/etc/cu/proxylog", "r");
	if (fp) {
		while (fgets(line, sizeof(line), fp)) {
			if (strstr(line, "CUPROXYLOG=\"anonym\"")) {
				snprintf(username, LOGIN_NAME_MAX, "anonym");
				break;
			}
		}
		fclose(fp);
	}

	// Pseudo on?
	if (!username[0]) {
		fp = fopen("/etc/cu/pseudoconf", "r");
		if (fp) {
			while (fgets(line, sizeof(line), fp)) {
				if (strstr(line, "CUPSEUDO=\"yes\"")) {
					union rsbac_target_id_t tid;
					union rsbac_attribute_value_t value;

					tid.user = pw->pw_uid;
					if (!rsbac_get_attr(0, SW_GEN, T_USER, &tid, A_pseudo, &value, 0) &&
						value.pseudo != 0) {
						snprintf(username, LOGIN_NAME_MAX, "%u", value.pseudo);
						break;
					}
				}
			}
			fclose(fp);
		}
	}

	// Normal username
	if (!username[0]) {
		snprintf(username, LOGIN_NAME_MAX, "%s", pw->pw_name);
	}

	return username;
}

char* replace_username_dir_for_logs(const char* path, const char* newname)
{
	if (!path || !newname) {
		log_error("%s: Neither path nor newname can be NULL", __func__);
		return NULL;
	}

	struct passwd* pw = getpwuid(geteuid());
	if (!pw) {
		log_error("%s: Failed to get username with pw", __func__);
		return NULL;
	}

	const char* oldname = pw->pw_name;

	char* outpath = (char*) malloc(PATH_MAX);
	if (!outpath) {
		log_error("%s: Failed to allocate memory for path", __func__);
		return NULL;
	}

	const char* p = path;
	char* out = outpath;
	size_t remaining = PATH_MAX;

	while (*p && remaining > 0) {
		if (strncmp(p, oldname, strlen(oldname)) == 0 &&
			(p[strlen(oldname)] == '/' || p[strlen(oldname)] == '\0') &&
			(p == path || *(p-1) == '/')) {

			size_t len = strlen(newname);
			if (len >= remaining) {
				free(outpath);
				return NULL;
			}
			memcpy(out, newname, len);
			out += len;
			p += strlen(oldname);
		} else {
			if (remaining < 2) {
				free(outpath);
				return NULL;
			}
			*out++ = *p++;
		}
		remaining = PATH_MAX - (out - outpath);
	}

	if (remaining == 0) {
		free(outpath);
		return NULL;
	}

	*out = '\0';
	return outpath;
}

#endif /* #if !defined(WIN32) && !defined(WIN64) && !defined(__APPLE__) */
