#ifndef TRANSFER_LOG_HELPERS_H
#define TRANSFER_LOG_HELPERS_H

#if !defined(WIN32) && !defined(WIN64) && !defined(__APPLE__)

#ifdef __cplusplus
extern "C" {
#endif

/**
 * Resolve the username to use in transfer logs.
 *
 * Checks proxy/pseudoconf settings and falls back to the effective UID username.
 *
 * @return A malloc'ed string containing the username. Must be freed by the caller.
 *    Returns NULL on failure.
 */
char* resolve_username_for_logs();

/**
 * Replace the username directory in a given path with a new username.
 *
 * Searches the path for the current username directory (from geteuid()) and
 * replaces it with the provided newname. Only directory names are replaced.
 *
 * @param path The original path.
 * @param newname The new username to replace in the path.
 * @return A malloc'ed string containing the new path. Must be freed by the caller.
 *		 Returns NULL on failure.
 */
char* replace_username_dir_for_logs(const char* path, const char* newname);

#ifdef __cplusplus
}
#endif

#endif /* #if !defined(WIN32) && !defined(WIN64) && !defined(__APPLE__) && !defined(rsbac_get_attr) */

#endif /* TRANSFER_LOG_HELPERS_H */
