/* Copyright 2016 Juan Garcia Basilio (j.garcia@m-privacy.de) for m-privacy GmbH
 *
 * This is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this software; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307,
 * USA.
 */

#if defined(WIN32) || defined(WIN64)

#include <windows.h>

char* getRegistryKeyValue(HKEY h_key, const char* key_directory, const char* key) {
	if (!h_key) {
		h_key = HKEY_CURRENT_USER;
	}
	char value[255];
	DWORD BufferSize = 4096;
	int ret = RegGetValue(h_key, key_directory, key, RRF_RT_ANY, NULL, (PVOID)&value, &BufferSize);
	return ret == ERROR_SUCCESS ? strdup(value) : NULL; // It returns an ERROR_FILE_NOT_FOUND (2) if the key doesn't exist
}
#endif /* if defined(WIN32) || defined(WIN64) */
