#ifdef __cplusplus
extern "C" {
#endif

#ifndef WINSCP_CONNECTOR_H
#define WINSCP_CONNECTOR_H


#define WINSCP_TIMEOUT 0
#define WINSCP_GOT_PROMPT 1
#define WINSCP_GOT_TARGET 2
#define WINSCP_GOT_TARGET_AND_PROMPT 3
#define WINSCP_GOT_CHANGED_KEY 4
#define WINSCP_GOT_NEW_KEY 5
#define WINSCP_CANCEL 6
#define WINSCP_RETRY 7
#define WINSCP_ERROR 8
#define WINSCP_WANTS_PASSWORD 9

void winscp_set_bin(const char* new_bin);
void winscp_set_ini(const char* new_ini);
const char* winscp_get_ini();
void winscp_start(char* session, const int open_immediately);
void winscp_start_interactive();
int winscp_open_connection(char* session);
int get_winscp_prompt_status();
void winscp_move(const char* filetype, const char* target_dir);
void winscp_copy(const char* filetype, const char* target_dir);
void winscp_cleanup();
char* winscp_get_host_fingerprint(const char* session);
void winscp_set_quick_print(int new_qp);
void winscp_send_command(char* winscp_command);
void winscp_cd_spool();


#endif /* WINSCP_CONNECTOR_H */

#ifdef __cplusplus
}
#endif
