Name:		rsbac
Version:	1.4.6
Release:	1%{?dist}
Summary:	RSBAC Admin Tools

Group:		System Environment/Base
License:	GPLv2
URL:		http://www.rsbac.org
Source0:	rsbac-admin-%{version}.tar.bz2
Patch0:		rsbac-admin-translation-fix.diff
BuildRoot:	%{_tmppath}/%{name}-%{version}-%{release}-root

BuildRequires:	libtool, gettext, ncurses-devel, pam-devel, nss-devel
Requires: dialog
Requires(post):	/sbin/chkconfig
Requires(preun): /sbin/chkconfig
Requires(preun): /sbin/service
Requires(pre): shadow-utils

%description
Bla, bla, bla

%package -n librsbac
Summary: librsbac
Group: System/Libraries

%description -n librsbac
librsbac

%package devel
Summary: Header files and static library for the rsbac
Group: Development/Libraries
Requires: librsbac = %{version}

%description devel
Bla, bla, bla devel

%package doc
Summary: rsbac doc
Group: System/Libraries

%description doc
Bla, bla, bla. rsbac-doc

%package -n nss_rsbac
Summary: NSS module for rsbac
Group:	System Environment/Base
Requires: %{name} = %{version}

%description -n nss_rsbac
Bla, bla, bla NSS

%package -n pam_rsbac
Summary: PAM rsbac
Group: System Environment/Base
Requires: %{name} = %{version}

%description -n pam_rsbac
Bla, bla, bla PAM

%prep
%setup -q -n rsbac-admin-%{version}
%patch0 -p0


%build
%{__make} build %{?_smp_mflags} LIBDIR=%{_libdir}

%define _pamdir /%{_lib}/security
%define _nssdir %{_libdir}

%define _syslib /%{_lib}/

%install
%{__rm} -rf %{buildroot}
%makeinstall PREFIX=%{_prefix} LIBDIR=%{_libdir} DESTDIR=%{buildroot} VERSION=%{version} DIR_PAM=%{_pamdir} DIR_NSS=%{_nssdir} DIR_DOC=%{_docdir}/%{name}-%{version}
%find_lang rsbac-tools
%find_lang pam_rsbac

mv -f %{buildroot}%{_libdir}/librsbac.so.* %{buildroot}%{_syslib}

rm -f %{buildroot}%{_nssdir}/libnss_rsbac.a %{buildroot}%{_nssdir}/libnss_rsbac.la

%clean
rm -rf $RPM_BUILD_ROOT

%post -n librsbac
/sbin/ldconfig

%pre -n rsbac
getent group secoff >/dev/null || groupadd -g 400 -r secoff
getent passwd secoff >/dev/null || \
	useradd -r -m -u 400 -g secoff -d /secoff -c "Security officer" -K UMASK=0077 secoff && \
	echo "umask 0077" >> /secoff/.bashrc

getent group audit >/dev/null || groupadd -g 401 -r audit
getent passwd audit >/dev/null || \
	useradd -r -m -u 401 -g audit -d /audit -c "Security audit" -K UMASK=0077 audit && \
	echo "umask 0077" >> /audit/.bashrc



%postun -n librsbac -p /sbin/ldconfig


%define bindir /bin

%files -f rsbac-tools.lang
%defattr(-,root,root,-)
%doc INSTALL README
%{bindir}/rsbac_login
%{_bindir}/acl_*
%{_bindir}/attr_*
%{_bindir}/auth_*
%{_bindir}/rsbac_*
%{_bindir}/mac_*
%{_bindir}/pm_*
%{_bindir}/rc_*
%{_bindir}/backup_*
%{_bindir}/get_attribute_*
%{_bindir}/linux2acl
%{_bindir}/net_temp
%{_bindir}/switch_*
%{_bindir}/user_aci.sh
%{_mandir}/man1/*

%files -n librsbac
%{_syslib}/librsbac.so.*

%files devel
%defattr(-,root,root,-)
%{_includedir}/rsbac/
%{_libdir}/librsbac.a
%{_libdir}/librsbac.so
%{_libdir}/librsbac.la

%files doc
%defattr(-,root,root,-)
%doc main/tools/examples

%define usbindir /usr/sbin

%files -n pam_rsbac -f pam_rsbac.lang
%{_pamdir}/pam_rsbac*

%files -n nss_rsbac
%{_libdir}/libnss_rsbac.so*

%changelog

