/*************************************************** */
/* Rule Set Based Access Control                     */
/*                                                   */
/* Author and (c) 1999-2016: Amon Ott <ao@rsbac.org> */
/*                                                   */
/* Last modified: 19/Sep/2016                        */
/*************************************************** */

#include <stdio.h>
#include <stdlib.h>
#include <rsbac/types.h>
#include <rsbac/syscalls.h>
#include <rsbac/error.h>
#include <rsbac/getname.h>
#include "nls.h"

int main(int argc, char ** argv)
{
  int res = 0;
  int res_min = 0;
  int res_max = 0;
  int scripting = 0;
  char * progname = argv[0];
  u_int stopflags = FALSE;

  while((argc > 1) && (argv[1][0] == '-') && !stopflags)
    {
      char * pos = argv[1];
      pos++;
      while(*pos)
        {
          switch(*pos)
            {
              case '-':
                stopflags = TRUE;
                break;
              case 's':
                scripting=1;
                break;
              case 'h':
                printf("Use: %s [flags]\n", progname);
                printf(gettext(" -h = this help, -- = no more flags,\n"));
                printf(gettext(" -s = scripting\n"));
                exit(0);
              default:
                fprintf(stderr, gettext("%s: unknown parameter %c\n"), progname, *pos);
                exit(1);
            }
          pos++;
        }
      argv++;
      argc--;
    }
  res = rsbac_version();
  if(res < 0) {
    show_error(res);
    res = 0;
  }

  res_min = rsbac_api_min_version();
  if(res_min < 0) {
//    show_error(res_min);
    res_min = RSBAC_VERSION_MAKE_NR(1, 4, 0);
  }

  res_max = rsbac_api_max_version();
  if(res_max < 0) {
//    show_error(res_max);
    res_max = RSBAC_VERSION_MAKE_NR(1, 5, 0);
  }

  if(scripting)
    printf("%u.%u.%u %u.%u.%u %u.%u.%u %u.%u.%u %u.%u.%u\n",
           RSBAC_VERSION_MAJOR,
           RSBAC_VERSION_MID,
           RSBAC_VERSION_MINOR,
           RSBAC_API_VERSION_MAJOR,
           RSBAC_API_VERSION_MID,
           RSBAC_API_VERSION_MINOR,
           res >> 16,
           res >> 8 & 255,
           res & 255,
           res_min >> 16,
           res_min >> 8 & 255,
           res_min & 255,
           res_max >> 16,
           res_max >> 8 & 255,
           res_max & 255);
  else
    printf("Tools:  %u.%u.%u, API: %u.%u.%u\nKernel: %u.%u.%u, API min: %u.%u.%u, API max: %u.%u.%u\n",
           RSBAC_VERSION_MAJOR,
           RSBAC_VERSION_MID,
           RSBAC_VERSION_MINOR,
           RSBAC_API_VERSION_MAJOR,
           RSBAC_API_VERSION_MID,
           RSBAC_API_VERSION_MINOR,
           res >> 16,
           res >> 8 & 255,
           res & 255,
           res_min >> 16,
           res_min >> 8 & 255,
           res_min & 255,
           res_max >> 16,
           res_max >> 8 & 255,
           res_max & 255);
  return 0;
}
