/*************************************************** */
/* Rule Set Based Access Control                     */
/*                                                   */
/* Author and (c) 1999-2019: Amon Ott <ao@rsbac.org> */
/*                                                   */
/* Last modified: 04/Jan/2019                        */
/*************************************************** */

#include <stdio.h>
#include <stdlib.h>
#include <rsbac/types.h>
#include <rsbac/syscalls.h>
#include <rsbac/error.h>
#include <rsbac/getname.h>
#include "nls.h"

int main(int argc, char ** argv)
{
  int res = 0;

 locale_init();

  res = rsbac_write();
  if(res<0)
    {
      error_exit(res);
    }
  else
    {
      printf(gettext("%s: list writing triggered successfully\n"), argv[0]);
      res = 0;
    }
    
  return (res);
}
