# Changelog
All notable changes to this project will be documented in this file. Format inspired by http://keepachangelog.com/ and this example https://github.com/olivierlacan/keep-a-changelog/blob/master/CHANGELOG.md

This is basically for the Windows version (the version numbers are not necessarily the same for Linux)

## [3.0.9] - rebased to upstream 794812dc76e3bce98c98772d5deabf7cc31ecd91
  - new branch rebase-20181019

## [3.0.8] - rebased to upstream d95be6c752d3658b7b5f41eb6971f49db59b3088
  - new branch rebase-20180830
  - Don't show some (known) errors when the connection fails while closing viewer
    (this happens sometimes due to some weird timing probably)

### Fixed
  - integer overflows in pixel size calculations

## [3.0.7]

### Fixed
- Freezes if connection to server is suddenly interrupted (also for laptops after stand-by).
  React to socket error 10054.

## [3.0.6]

### Fixed
  - Sporadic freezes while logging out. React to socket error 10053.

## [3.0.5] - New upstream code

### Fixed
  - Minor fixes in special key handling in Windows
  - Using their implementation of 'copy' clipboard only when viewer window is focused
  - Fixed NumLock and CapsLock bug.
  - Fixed some socket errors

## [3.0.4]

### Changed
 - Do not use SO_LINGER in TCP sockets

## [3.0.3] - New upstream code

### Added
  - Autotransfer

### Fixed
  - NumLock and CapsLock bug (dirty-work around: nicely solved upstream and available in 3.0.5)
  - Crash while printing certain pdf files (libcairo problem)

### Changed (this is actually for the server side, but might be interesting)
  - Huge Active Directory rebase (including new 'realms' auth method).

## [3.0.2]

### Fixed
 - Only send clipboard when entering window to avoid traffic and sending
   potentially confidential data without need
 - Signal audio problems from client to server to avoid hangs
 - Fix race with double connections to local Pulseaudio

## [3.0.1]

### Updated
 - Newest TLS (had to force allow of old SHA1)

### Fixed
 - Reduced logout time
 - tgpro.vnc not being saved (there was also a problem specifically with geometry and
   desktopSize not being saved).

## [3.0.0]
### Updated
 - Actually everything (maybe upstream), this has been a huge rebase on
   the newest upstream sources. Thanks for that, Amon!

### Regression bugs
 - tgpro.vnc config not saved
 - slow logout

## [2.1.21]

### Fixed
 - You can now move the vnc config ordner and the x509 certificates will continue to work
 - Start Firefox regardless of the noautobrowser files when opening a link with magic url
 - (Linux viewer only) Delete /tmp/.magicurlXXX only if it belongs to the current user
 - Add PrintSupport, SoundSupport and StandardBrowser values to connection info window.
   And remove a lot of useless information from it too.

## [2.1.20]

### Fixed
 - Catch empty host parameter.

## [2.1.19]

### Added
 - Support for multi-part Multi packets, to be reassembled before calling callback. Needs this version at server and client to work.
 - This feature is supposed to fix audio problems with oversized PulseAudio buffers.

## [2.1.18]

### Added
 - Support for several monitors. The viewer saves its position if not on main display too.

## [2.1.17]

## [2.1.16]

### Fixed
 - Optimised video and audio transfer to avoid stuttering
 - Bug in magicurl (viewer) that produced a crash while starting the viewer

## [2.1.15] - 2016-11-10

### Added
 - Keep-alive: periodically check if viewer is still connected and kill session if not.

### Changed
 - Logging: Only log keys pressed with level >= 102, TLS >= 110.

## [2.1.13] - 2016-11-01

### Changes
 - Minor changes in X (tightgateviewer server mostly)

### Added
 - Multi-user MagicUrl (multi only)

## [2.1.11]

### Fixed

 - Blurry printing problem

### Changed

 - Higher definition icon

## [2.1.10]

### Fixed

 - Link opening twice

## [2.1.9]

### Added

 - Use magic url's new ability to set and use -configdir. Opening a link when the viewer is not running should work now.

## [2.1.8]

### Added

 - TightGate-Viewer as standard browser: dialog on start-up and option the options dialog.

### Fixed


## [2.1.7]

### Added
 - Does a lot of stuff
